/*
 * Decompiled with CFR 0.152.
 */
package fr.minecraftforgefrance.common;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import fr.minecraftforgefrance.common.Localization;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.tukaani.xz.XZInputStream;

public class DownloadUtils {
    public static final String LIBRARIES_URL = "https://libraries.minecraft.net/";
    public static final String PACK_NAME = ".pack.xz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(URL url, File dest, JProgressBar bar, JProgressBar fullBar, JLabel speedLabel) {
        bar.setIndeterminate(true);
        OutputStream fos = null;
        BufferedReader reader = null;
        try {
            int n;
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            URL url2 = uri.toURL();
            URLConnection connection = url2.openConnection();
            int fileLength = connection.getContentLength();
            if (fileLength == -1) {
                System.err.println(String.format(Localization.LANG.getTranslation("err.invalidurl"), url2.toString()));
                boolean bl = false;
                return bl;
            }
            bar.setMaximum(fileLength);
            InputStream in = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in));
            fos = new FileOutputStream(dest);
            long downloadStartTime = System.currentTimeMillis();
            int downloadedAmount = 0;
            byte[] buff = new byte[1024];
            bar.setValue(0);
            bar.setIndeterminate(false);
            while ((n = in.read(buff)) != -1) {
                ((FileOutputStream)fos).write(buff, 0, n);
                bar.setValue(bar.getValue() + n);
                fullBar.setValue(fullBar.getValue() + n);
                downloadedAmount += n;
                long timeLapse = System.currentTimeMillis() - downloadStartTime;
                if (timeLapse < 1000L) continue;
                float downloadSpeed = (float)downloadedAmount / (float)timeLapse;
                downloadedAmount = 0;
                downloadStartTime += 1000L;
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(2);
                if (downloadSpeed > 1000.0f) {
                    speedLabel.setText(Localization.LANG.getTranslation("misc.speed") + " : " + String.valueOf(df.format(downloadSpeed / 1024.0f)) + " mo/s");
                    continue;
                }
                speedLabel.setText(Localization.LANG.getTranslation("misc.speed") + " : " + String.valueOf(df.format(downloadSpeed)) + " ko/s");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean checksumValid(File libPath, List<String> checksums) {
        try {
            boolean valid;
            byte[] fileData = Files.toByteArray(libPath);
            boolean bl = valid = checksums == null || checksums.isEmpty() || checksums.contains(Hashing.sha1().hashBytes(fileData).toString());
            if (!valid && libPath.getName().endsWith(".jar")) {
                valid = DownloadUtils.validateJar(libPath, fileData, checksums);
            }
            return valid;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean validateJar(File libPath, byte[] data, List<String> checksums) throws IOException {
        System.out.println(Localization.LANG.getTranslation("proc.checkingchecksum").replace("$p", libPath.getAbsolutePath()));
        HashMap<String, String> files = new HashMap<String, String>();
        String[] hashes = null;
        JarInputStream jar = new JarInputStream(new ByteArrayInputStream(data));
        JarEntry entry = jar.getNextJarEntry();
        while (entry != null) {
            byte[] eData = DownloadUtils.readFully(jar);
            if (entry.getName().equals("checksums.sha1")) {
                hashes = new String(eData, Charset.forName("UTF-8")).split("\n");
            }
            if (!entry.isDirectory()) {
                files.put(entry.getName(), Hashing.sha1().hashBytes(eData).toString());
            }
            entry = jar.getNextJarEntry();
        }
        jar.close();
        if (hashes != null) {
            boolean failed;
            boolean bl = failed = !checksums.contains(files.get("checksums.sha1"));
            if (failed) {
                System.err.println(Localization.LANG.getTranslation("err.checksumvalidation"));
            } else {
                System.out.println(Localization.LANG.getTranslation("file.checksumvalidation.success"));
                for (String hash : hashes) {
                    if (hash.trim().equals("") || !hash.contains(" ")) continue;
                    String[] e = hash.split(" ");
                    String validChecksum = e[0];
                    String target = e[1];
                    String checksum = (String)files.get(target);
                    if (!files.containsKey(target) || checksum == null) {
                        System.err.println("    " + target + " : " + Localization.LANG.getTranslation("misc.missing").toLowerCase());
                        failed = true;
                        continue;
                    }
                    if (checksum.equals(validChecksum)) continue;
                    System.err.println("    " + target + " : " + Localization.LANG.getTranslation("misc.failed").toLowerCase() + " (" + checksum + ", " + validChecksum + ")");
                    failed = true;
                }
            }
            if (!failed) {
                System.out.println(Localization.LANG.getTranslation("jar.validated.success"));
            }
            return !failed;
        }
        System.out.println(Localization.LANG.getTranslation("err.checksumnotfound"));
        return false;
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    public static void unpackLibrary(File output, byte[] data) throws IOException {
        byte[] decompressed;
        String end;
        if (output.exists()) {
            output.delete();
        }
        if (!(end = new String(decompressed = DownloadUtils.readFully(new XZInputStream(new ByteArrayInputStream(data))), decompressed.length - 4, 4)).equals("SIGN")) {
            System.err.println(Localization.LANG.getTranslation("err.missingsignature") + " : " + end);
            return;
        }
        int x = decompressed.length;
        int len = decompressed[x - 8] & 0xFF | (decompressed[x - 7] & 0xFF) << 8 | (decompressed[x - 6] & 0xFF) << 16 | (decompressed[x - 5] & 0xFF) << 24;
        byte[] checksums = Arrays.copyOfRange(decompressed, decompressed.length - len - 8, decompressed.length - 8);
        FileOutputStream jarBytes = new FileOutputStream(output);
        JarOutputStream jos = new JarOutputStream(jarBytes);
        Pack200.newUnpacker().unpack((InputStream)new ByteArrayInputStream(decompressed), jos);
        jos.putNextEntry(new JarEntry("checksums.sha1"));
        jos.write(checksums);
        jos.closeEntry();
        jos.close();
        jarBytes.close();
    }
}

